' VBScript source code
dim jobNumber, jobFile, jobSeed

'----------------------------------------------------------
'Change these values to match your settings and job number

jobNumber    = "10"
jobFile      = "job.xml"
jobSeed      = "BreastCancer.gep"

serverShare = "jobs"
serverShareLocation = "c:\jobs"
folderStructure = "\job{NUMBER}"

'The possible values of clusterArchitecture are:
' x86 - All the operating systems in the cluster are 32 bit machines
' x64 - All the operating systems in the cluster are 64 bit machines
' mixed - The cluster has both 32 and 64 bit operating systems (You will have to add the location of GeneXproServer to the path of each server)
clusterArchitecture="x86"

'----------------------------------------------------------
'Change the number below to the number of servers in your cluster
dim ServerNames(2)

'Add as many names as there are computers in your cluster incrementing the number between brackets.
ServerNames(0) = "server01"
ServerNames(1) = "server02"

'----------------------------------------------------------
'Main Program
if CreateFolders() then
    ModifyJobFiles
    
    select case clusterArchitecture
		case "x86"
		serverGxpsLocation = """c:\Program Files\GeneXproServer 1.0\GeneXproServerConsole.exe"""
		case "x64"
		serverGxpsLocation = """C:\Program Files (x86)\GeneXproServer 1.0\GeneXproServerConsole.exe"""
		case "mixed"
		serverGxpsLocation = "GeneXproServerConsole.exe"
    end select 
    
    StartRuns
end if

'----------------------------------------------------------
'Create one folder per computer in the cluster
'using the file spec above.
function CreateFolders()
    WScript.StdOut.WriteLine "Creating folders..."
    on error resume next
    
    dim fso, n, folder, res
    set fso = WScript.CreateObject("Scripting.FileSystemObject")
    
    for n=0 to ubound(ServerNames)
        if len(ServerNames(n)) > 0 then
            
            folder = "\\" & ServerNames(n) _
                   & "\" & serverShare _
                   & GetFolderName
            
            if fso.FolderExists(folder) then
                res = MsgBox("Folder " & folder & " already exists." & vbCR _
                    & vbCR & "Do you want to delete it and continue?", vbQuestion + vbYesNo, "Simple GeneXproServer Cluster")
                if res = vbYes then
                    fso.DeleteFolder folder, True
                else
                    exit function
                end if
            end if
            
            fso.CreateFolder folder
            WScript.StdOut.WriteLine "Created folder " & folder
            
            if Err then
                WScript.StdOut.WriteLine "Error creating folder " & folder
                WScript.StdOut.WriteLine Err.Description
                exit for
            end if
        end if
    next
    CreateFolders = not Err
end function

'----------------------------------------------------------
'Change the path attribute of the node job in the job
'definition file.
sub ModifyJobFiles()
      
    dim doc
    set doc = CreateObject("MSXML.DomDocument")
    
    if doc.Load(jobFile) then
        dim jobNode
        set jobNode = doc.documentElement.SelectSingleNode("//job")
        jobNode.Attributes(0).Text = jobSeed
        jobNode.Attributes(1).Text = serverShareLocation & GetFolderName
        doc.Save jobFile
    end if
    set doc = nothing

end sub

'----------------------------------------------------------
' Copy the files to each server and kickof the run.
sub StartRuns()
    
    on error resume next
    dim fso, n, folder, wmiService, proc, ret, execComm, pid
    set fso = WScript.CreateObject("Scripting.FileSystemObject")
        
    for n=0 to ubound(ServerNames)
        if len(ServerNames(n)) > 0 then
            
            folder = "\\" & ServerNames(n) _
                   & "\" & serverShare _
                   & GetFolderName _
                   & "\"
            
            WScript.StdOut.WriteLine "Copying files to " & ServerNames(n) & "..."
            fso.CopyFile jobFile, folder & jobFile
            fso.CopyFile jobSeed, folder & jobSeed
            WScript.StdOut.WriteLine "Starting remote run..."
            
            Set wmiService = GetObject("winmgmts:\\" & ServerNames(n) & "\root\cimv2")
			Set proc = wmiService.Get("Win32_Process")
			            
			execComm = serverGxpsLocation & " " & serverShareLocation _
                     & GetFolderName & "\" & jobFile
            
            pid = 0
            ret = proc.Create(execComm, , , pid)
            
            if pid > 0 then
                WScript.StdOut.WriteLine "Done."
            else
                WScript.StdOut.WriteLine "FAILED!"
            end if
            
            if Err then
                WScript.StdOut.WriteLine "Error creating a run in " & ServerNames(n)
                WScript.StdOut.WriteLine Err.Description
                exit for
            end if
        end if
    next
end sub

'----------------------------------------------------------
' Returns the folder of the current job. For example: \job1
function GetFolderName()
    GetFolderName = replace(folderStructure, "{NUMBER}", jobNumber)
end function


